<!DOCTYPE html>
<html lang="ru">
<head>
	{headers}
	<meta name="viewport" content="width=device-width, initial-scale=1.0" />
	<link rel="shortcut icon" href="{THEME}/images/logo.svg" />
	<link href="{THEME}/css/styles.css" type="text/css" rel="stylesheet" />
	<link href="{THEME}/css/engine.css" type="text/css" rel="stylesheet" />
	<meta name="theme-color" content="#f5f6f8">
	<link href="https://fonts.googleapis.com/css?family=Montserrat:300,400,500,600&display=swap&subset=cyrillic" rel="stylesheet">  
</head>

<body>

	<div class="wrap">
		
		<div class="wrap-main wrap-center">
	
			<header class="header fx-row fx-middle">
				<a href="/" class="logo nowrap"><span>Your</span>Sitelogo<span class="logo-domain">.com</span></a>
				<div class="search-wrap fx-1">
					<form id="quicksearch" method="post">
						<input type="hidden" name="do" value="search" />
						<input type="hidden" name="subaction" value="search" />
						<div class="search-box">
							<input id="story" name="story" placeholder="Поиск по сайту..." type="text" />
							<button type="submit" class="search-btn"><span class="fal fa-search"></span></button>
						</div>
					</form>
				</div>
				[group=5]<div class="header-btn btn js-login">Войти</div>[/group]
				[not-group=5]<div class="header-btn btn js-login">Кабинет</div>[/not-group]
				<div class="btn-menu hidden"><span class="fal fa-bars"></span></div>
			</header>
			
			<!-- END HEADER -->

			[available=main]
			<div class="carou-sect">
				<div class="carou-title">Популярные сериалы</div>
				<div class="carou-content">
					<div class="owl-carousel" id="owl-popular">
						{custom limit="14" template="custom-popular" cache="no"}
					</div>
				</div>
			</div>
			[/available]
			
			<div class="cols fx-row">

				<aside class="sidebar">
					<div class="side-box side-nav to-mob">
						<div class="side-bt">Наше меню</div>
						<div class="side-bc fx-row">
							<div class="nav-col">
								<div class="nav-title">Заголовок</div>
								<ul class="nav-menu">
									<li><a href="">Раздел</a></li>
									<li><a href="">Раздел</a></li>
									<li><a href="">Раздел</a></li>
									<li><a href="">Раздел</a></li>
									<li><a href="">Раздел</a></li>
									<li><a href="">Раздел</a></li>
									<li><a href="">Раздел</a></li>
									<li><a href="">Раздел</a></li>
									<li><a href="">Раздел</a></li>
								</ul>
							</div>
							<div class="nav-col">
								<div class="nav-title">Заголовок</div>
								<ul class="nav-menu">
									<li><a href="">Раздел</a></li>
									<li><a href="">Раздел</a></li>
									<li><a href="">Раздел</a></li>
								</ul>
								<div class="nav-title">Заголовок</div>
								<ul class="nav-menu">
									<li><a href="">Раздел</a></li>
									<li><a href="">Раздел</a></li>
									<li><a href="">Раздел</a></li>
								</ul>
							</div>
						</div>
					</div>
					<div class="side-box to-mob">
						<div class="side-bt">Популярные сериалы</div>
						<div class="side-bc">
							{custom template="custom-side-popular" from="0" limit="5" cache="no"}
						</div>
					</div>
					<div class="side-box to-mob">
						<div class="side-bt">Рекомендуем посмотреть</div>
						<div class="side-bc fx-row mb-remove">
							{custom template="custom-side-recommend" from="0" limit="4" cache="no"}
						</div>
					</div>
					<div class="side-box">
						<div class="side-bt">Последние комментарии</div>
						<div class="side-bc">
							{customcomments template="custom-comms" from="0" limit="5" cache="no"}
						</div>
					</div>
				</aside>

				<!-- END SIDEBAR -->
				
				<main class="main fx-1">
					{info}
					[available=main|cat]
					<div class="sect">
						<div class="sect-header fx-row fx-middle">
							[available=main]<div class="sect-title fx-1 nowrap"><span class="fal fa-film"></span>Последние новинки</div>[/available]
							[available=cat]<div class="sect-title fx-1 nowrap"><span class="fal fa-film"></span>{category-title}</div>[/available]
							[sort]<div class="sorter anim" data-label="По ">{sort}</div>[/sort]
						</div>
						<div class="sect-content">{content}</div>
					</div>
					[/available]
					[not-available=main|cat]
					<div class="speedbar nowrap"><span class="fal fa-home"></span>{speedbar}</div>
					{content}
					[/not-available]
					{include file="main-seo.tpl"}
				</main>

				<!-- END MAIN -->

			</div>
			
			<!-- END COLS -->
			
			<footer class="footer fx-row fx-middle">
				<div class="footer-copyright fx-1">
					© 2020 YourSitename.com, все защищено по самые помидоры.  
					<a href="#">Правообладателям</a>
				</div>
				<div class="footer-counter"><img src="{theme}/images/counter.gif" alt=""></div>
			</footer>
			
			<!-- END FOOTER -->
			
		</div>

		<!-- END WRAP-MAIN -->

	</div>
	
	<!-- END WRAP -->
		
{login}
{jsfiles}
<script src="{THEME}/js/libs.js"></script>
{AJAX}


</body>
</html>
