var tinymce_dle_plugin_loaded = false;
var playlist = '';

function DLEclearPasteText(text, editor) {
	
	text = text.replace(/<!\[if !support.*?]>.*?<!\[endif]>/gis, '').replace(/<xml>.*?<\/xml>/gis, '').replace(/<\?xml[^>]*>/gi, '');
	text = text.replace(/<\/?w:[^>]+>/gi, '');
	text = text.replace(/<\/?o:[^>]+>/gi, '');
	text = text.replace(/<span(?=\s|>)(?![^>]*\bstyle=)[^>]*>(.*?)<\/span>/gi, '$1');
	text = text.replace(/(<[a-z][^>]*?)\sdata-[a-zA-Z0-9-]+="[^"]*"/gi, '$1');
	text = text.replace(/(<[a-z][^>]*?)\s*lang="[^"]*"/gi, '$1');
	text = text.replace(/(<[a-z][^>]*?)\s*v:shapes="[^"]*"/gi, '$1');
	text = text.replace(/<strong[^>]*>/gi, '<b>');
	text = text.replace(/<\/strong>/gi, '</b>');
	text = text.replace(/<em[^>]*>/gi, '<i>');
	text = text.replace(/<\/em>/gi, '</i>');

	text = text.replace(/style="([^"]*)"/gi, (match, stylesContent) => {
		const allowedProperties = ['color', 'background*', "font-size", "text-align", "border*", "margin*", "padding*", "display"];

		const escapeRegExp = (string) => string.replace(/[.*+?^${}()|[\]\\]/g, '\\$&');

		const filteredStyles = stylesContent
			.split(';')
			.map(prop => prop.trim())
			.filter(prop => {
				if (!prop) return false;

				return allowedProperties.some(allowedProp => {
					if (allowedProp.endsWith('*')) {
						const prefix = allowedProp.slice(0, -1).toLowerCase();
						return prop.toLowerCase().startsWith(prefix);
					}
					else {
						const regex = new RegExp(`^${escapeRegExp(allowedProp)}\\s*:`, 'i');
						return regex.test(prop);
					}
				});
			});

		return filteredStyles.length > 0
			? `style="${filteredStyles.join('; ')}"`
			: '';
	});

	text = text.replace(/class="([^"]*)"/gi, (match, classesContent) => {
		const allowedClasses = ['noncontenteditable', 'contenteditable', 'highslide', 'quote_block', 'quote', 'quote_body', 'title_quote', 'language-*'];

		const allowedPatterns = allowedClasses.map(pattern => {
			const lowerPattern = pattern.toLowerCase();
			if (lowerPattern.includes('*')) {
				const parts = lowerPattern.split('*').map(part =>
					part.replace(/[+?^${}()|[\]\\]/g, '\\$&')
				);
				const regexPattern = '^' + parts.join('.*') + '$';
				return new RegExp(regexPattern);
			}
			return lowerPattern;
		});

		const filteredClasses = classesContent
			.split(/\s+/)
			.map(className => className.trim()) // Чистим пробелы
			.filter(className => {
				if (!className) return false;

				const lowerClassName = className.toLowerCase();

				return allowedPatterns.some(pattern => {
					if (pattern instanceof RegExp) {
						return pattern.test(lowerClassName);
					}
					return lowerClassName === pattern;
				});
			});

		return filteredClasses.length > 0
			? `class="${filteredClasses.join(' ')}"`
			: '';
	});

	text = text.replace(/<span\s+>/gi, '<span>');
	text = text.replace(/&nbsp;/g, ' ');
	text = text.replace(/<!--[\s\S]*?-->/g, '');

	const parser = new DOMParser();
	const doc = parser.parseFromString(text, 'text/html');

	const processNode = (node) => {
		const children = Array.from(node.childNodes);

		children.forEach(child => {
			if (child.nodeType === Node.ELEMENT_NODE) {
				processNode(child);
			}
		});

		if (node.nodeType === Node.ELEMENT_NODE && node.tagName.toLowerCase() === 'p') {
			if (node.textContent.trim() === '') {
				node.parentNode?.removeChild(node);
			}
		}

		if (node.nodeType === Node.ELEMENT_NODE &&
			node.tagName.toLowerCase() === 'span' &&
			node.attributes.length === 0) {

			const parent = node.parentNode;
			if (parent) {
				while (node.firstChild) {
					parent.insertBefore(node.firstChild, node);
				}
				parent.removeChild(node);
			}
		}
	};

	processNode(doc.body);
	text = doc.body.innerHTML;

	text = text.replace(/<td([^>]*)>(\s|&nbsp;)*<\/td>/gi, '<td$1><p></p></td>');

	var allow_links = true;

	if (typeof editor != "undefined") {
		var state = null

		try {
			state = localStorage.getItem('dle_editor_pastetext_' + editor.id);
		} catch (e) { }

		if (state) {
			allow_links = false;
		}
	}
	
	if (allow_links) {

		var existingLinks = [];

		text = text.replace(/<a[^>]*?href=["'](https?:\/\/[^\s<]+)["'][^>]*?>.*?<\/a>/gi, match => {
			existingLinks.push(match);
			return `__LINK${existingLinks.length - 1}__`;
		});

		text = text.split(/(<[^>]+>)/g).map(part => {
			if (part.startsWith('<')) {
				return part;
			} else {
				return part.replace(
					/(https?:\/\/[^\s"'<>{}\[\]]+)/g, (match, url, offset, string) => {
						var prevChar = string[offset - 1];
						if (prevChar === '[' || prevChar === ']' || prevChar === '=') {
							return url;
						} else {
							return `<a href="${url}">${url}</a>`;
						}
					}
				);
			}
		}).join('');

		existingLinks.forEach((link, index) => {
			text = text.replace(`__LINK${index}__`, link);
		});

	}

	return text;
}

tinymce.PluginManager.add('dlebutton', function(editor, url) {
    editor.on('init', function() {

    	if (!tinymce_dle_plugin_loaded) {

    		tinymce_dle_plugin_loaded = true;
    		
	        var cssURL = url + '/dlebutton.css?v=192';

	        var cssLink = editor.dom.create('link', {rel: 'stylesheet', href: cssURL });
	        
	        document.getElementsByTagName('body')[0].appendChild(cssLink);

	    }
		
		var state = null

		try {
			state = localStorage.getItem('dle_editor_pastetext_' + editor.id);
		} catch (e) { }
	
		if (state) {

			setTimeout(function (){
				
				const origFocus = editor.focus;
				const origScrollIntoView = editor.dom.getRoot().scrollIntoView;

				editor.focus = () => { };
				editor.dom.getRoot().scrollIntoView = () => { };

				editor.execCommand('mceTogglePlainTextPaste');

				editor.focus = origFocus;
				editor.dom.getRoot().scrollIntoView = origScrollIntoView;

				$('#' + editor.id).next().find('button[data-mce-name="pastetext"]').addClass('tox-tbtn--enabled');

			}, 200);
		}

    });

	var set_scrollbar = false;

	editor.on('OpenWindow', (e) => {

		if ($(document).height() > $(window).height() && $('html').css('scrollbar-gutter') !== 'stable' ) {
			$("html").css("scrollbar-gutter", "stable");
			set_scrollbar = true;
		}

		if($('[role="tablist"]').children().length && $('[role="tablist"]').children().length == 1) {
			$('[role="tablist"]').remove();
		}

		var tabpanel = $('[role="tabpanel"]');
		if (tabpanel.length) {
			tabpanel.addClass('auto_height');
			setTimeout(function() {
			    var lastChild = tabpanel.children().last();
			    if (lastChild.length) {
			        var lastHeight = lastChild.outerHeight(true);
			        var paddingTop = parseFloat(tabpanel.css("padding-top")) || 0;
			        var paddingBottom = parseFloat(tabpanel.css("padding-bottom")) || 0;
			        var totalHeight = lastHeight + paddingTop + paddingBottom;
			        tabpanel.css("height", totalHeight + "px");
			        tabpanel.css("flex-basis", totalHeight + "px");
			    }
			    tabpanel.removeClass('auto_height');
			}, 300);
		}


	});
	editor.on('CloseWindow', (e) => {
		if (set_scrollbar) {
			$("html").css("scrollbar-gutter", "");
		}
		set_scrollbar = false;
	});

	editor.on('FormatApply', function (format) {

		try {
			var custom_blocks = ['custom-information block', 'custom-warning block', 'custom-error block', 'custom-blue background', 'custom-gray background', 'custom-green background', 'custom-brown background', 'custom-borders', 'custom-borders top and bottom'];
			if ( format.format && custom_blocks.includes(format.format) ) {
				var node = editor.selection.getNode();

				if (node.nodeName == 'DIV' || node.nodeName == 'P') {
					if (node.nodeName == 'P') { 
						el = node.parentNode;
					} else {
						el = node;
					}

					var object = $(el);
					var style = object.attr("style");
					var nextElement = object.next();
					var setlast = '<p></p>';

					object.find('p').last().append('<span id="mce_cursor"></span>');

					if (nextElement.length ) {
						setlast = '';
					}

					object.addClass("contenteditable");
					object.removeAttr('style');
					editor.selection.select(el);

					editor.insertContent('<div style="' + style + '" class="noncontenteditable">' + object.prop('outerHTML').replace("<br data-mce-bogus=\"1\">", "<br>") + '</div>' + setlast);
					
					var target = editor.dom.get('mce_cursor');

					if ( target && target.parentNode ) {
						var parent = target.parentNode;

						editor.selection.setCursorLocation(parent, Array.prototype.indexOf.call(parent.childNodes, target) + 1);
					}

					editor.dom.remove(editor.dom.select('span#mce_cursor'));
				}
			}

		} catch (e) { }

	});

	editor.on('PastePlainTextToggle', function (state) {

		if ( state.state ) {
			
			try {
				localStorage.setItem('dle_editor_pastetext_' + editor.id, '1');
			} catch (e) { }

		} else {

			try {
				localStorage.removeItem('dle_editor_pastetext_' + editor.id);
			} catch (e) { }

		}

	});

    var scriptLoader = new tinymce.dom.ScriptLoader();
    var tp;

    scriptLoader.add(url + '/typograf.min.js');

	scriptLoader.loadQueue().then(() => {
    	tp = new Typograf({
    		locale: ['ru', 'en-US'],
    		htmlEntity: {type: 'name', onlyInvisible: true}
		});

		tp.addSafeTag('\\[code\\]', '\\[/code\\]');
		tp.addSafeTag('\\[', '\\]');
		tp.addSafeTag('<code>', '</code>');
	});
	
	editor.options.register('dle_root', {
	  processor: 'string',
	  default: '/'
	});

	editor.options.register('dle_upload_area', {
	  processor: 'string',
	  default: ''
	});

	editor.options.register('dle_upload_user', {
	  processor: 'string',
	  default: ''
	});

	editor.options.register('dle_upload_news', {
	  processor: 'string',
	  default: ''
	});

	editor.ui.registry.addIcon('icon-up', '<svg xmlns="http://www.w3.org/2000/svg" width="23" height="23" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" style="fill:none!important;"><path d="M20 20a2 2 0 0 0 2-2V8a2 2 0 0 0-2-2h-7.9a2 2 0 0 1-1.69-.9L9.6 3.9A2 2 0 0 0 7.93 3H4a2 2 0 0 0-2 2v13a2 2 0 0 0 2 2Z"/><path d="M12 10v6"/><path d="m9 13 3-3 3 3"/></svg>');
	editor.ui.registry.addIcon('icon-leech', '<svg height="20" width="20" viewBox="0 0 32 32"><path d="M18.532 19.468l-4.532 4.532h-3v3h-3v3h-5v-5l10.532-10.532c-0.344-0.924-0.532-1.924-0.532-2.968 0-4.694 3.806-8.5 8.5-8.5s8.5 3.806 8.5 8.5c0 4.694-3.806 8.5-8.5 8.5-1.044 0-2.044-0.188-2.968-0.532v0 0zM27 9c0-1.657-1.343-3-3-3s-3 1.343-3 3c0 1.657 1.343 3 3 3s3-1.343 3-3v0z"></path></svg>');
	editor.ui.registry.addIcon('icon-audio', '<svg height="18" width="18" viewBox="0 0 32 32"><path d="M30 0h2v23c0 2.761-3.134 5-7 5s-7-2.239-7-5c0-2.761 3.134-5 7-5 1.959 0 3.729 0.575 5 1.501v-11.501l-16 3.556v15.444c0 2.761-3.134 5-7 5s-7-2.239-7-5c0-2.761 3.134-5 7-5 1.959 0 3.729 0.575 5 1.501v-19.501l18-4z"></path></svg>');
	editor.ui.registry.addIcon('icon-yt', '<svg height="20" width="20" viewBox="0 0 32 32"><path d="M4.549 1.76c-1.571 0-2.112 0.163-2.708 0.488-0.579 0.311-1.043 0.773-1.346 1.335l-0.009 0.017c-0.324 0.597-0.487 1.137-0.487 2.761v12.183c0 1.571 0.163 2.113 0.487 2.708 0.325 0.596 0.76 1.029 1.355 1.355 0.541 0.325 1.084 0.487 2.708 0.487h3.627l1.517-1.787h-5.685c-0.433 0.055-0.92-0.001-1.355-0.219-0.271-0.107-0.488-0.377-0.651-0.648-0.163-0.433-0.271-0.867-0.216-1.355v-13.211c-0.053-0.433 0-0.92 0.216-1.353 0.108-0.271 0.38-0.487 0.651-0.649 0.433-0.163 0.867-0.272 1.355-0.219h23.823c0.433-0.053 0.92 0.003 1.355 0.219 0.271 0.109 0.485 0.379 0.648 0.649 0.163 0.432 0.271 0.867 0.216 1.353v13.267c0.053 0.432 0 0.92-0.216 1.353-0.108 0.271-0.377 0.487-0.648 0.648-0.433 0.163-0.867 0.271-1.355 0.217h-5.685l1.516 1.788 3.737-0.053c1.624 0 2.164-0.163 2.76-0.488 0.58-0.312 1.043-0.775 1.346-1.337l0.009-0.017c0.324-0.541 0.487-1.084 0.487-2.707v-12.185c0-1.624-0.163-2.164-0.487-2.76-0.312-0.579-0.775-1.042-1.337-1.345l-0.017-0.009c-0.596-0.325-1.136-0.488-2.76-0.488zM15.817 18.024c-0.2 0.009-0.376 0.103-0.492 0.248l-0.001 0.001-9.475 10.883c-0.102 0.11-0.164 0.258-0.164 0.42 0 0.005 0 0.010 0 0.015v-0.001c-0 0.007-0 0.015-0 0.023 0 0.346 0.281 0.627 0.627 0.627 0.009 0 0.017-0 0.026-0l-0.001 0h19.057c0.163 0 0.327-0.053 0.435-0.161 0.271-0.217 0.272-0.652 0.055-0.923l-9.531-10.936c-0.139-0.122-0.321-0.196-0.522-0.196-0.005 0-0.009 0-0.014 0h0.001z"></path></svg>');
	editor.ui.registry.addIcon('icon-pl', '<svg height="20" width="20" viewBox="0 0 32 32"><path d="M12 6h4v2h-4zM18 6h4v2h-4zM28 6v8h-6v-2h4v-4h-2v-2zM10 12h4v2h-4zM16 12h4v2h-4zM6 8v4h2v2h-4v-8h6v2zM12 18h4v2h-4zM18 18h4v2h-4zM28 18v8h-6v-2h4v-4h-2v-2zM10 24h4v2h-4zM16 24h4v2h-4zM6 20v4h2v2h-4v-8h6v2zM30 2h-28v28h28v-28zM32 0v0 32h-32v-32h32z"></path></svg>');
	editor.ui.registry.addIcon('icon-hide', '<svg height="20" width="20" viewBox="0 0 32 32"><path d="M29.561 0.439c-0.586-0.586-1.535-0.586-2.121 0l-6.318 6.318c-1.623-0.492-3.342-0.757-5.122-0.757-6.979 0-13.028 4.064-16 10 1.285 2.566 3.145 4.782 5.407 6.472l-4.968 4.968c-0.586 0.586-0.586 1.535 0 2.121 0.293 0.293 0.677 0.439 1.061 0.439s0.768-0.146 1.061-0.439l27-27c0.586-0.586 0.586-1.536 0-2.121zM13 10c1.32 0 2.44 0.853 2.841 2.037l-3.804 3.804c-1.184-0.401-2.037-1.521-2.037-2.841 0-1.657 1.343-3 3-3zM3.441 16c1.197-1.891 2.79-3.498 4.67-4.697 0.122-0.078 0.246-0.154 0.371-0.228-0.311 0.854-0.482 1.776-0.482 2.737 0 1.715 0.54 3.304 1.459 4.607l-1.904 1.904c-1.639-1.151-3.038-2.621-4.114-4.323z"></path><path d="M24 13.813c0-0.849-0.133-1.667-0.378-2.434l-10.056 10.056c0.768 0.245 1.586 0.378 2.435 0.378 4.418 0 8-3.582 8-8z"></path><path d="M25.938 9.062l-2.168 2.168c0.040 0.025 0.079 0.049 0.118 0.074 1.88 1.199 3.473 2.805 4.67 4.697-1.197 1.891-2.79 3.498-4.67 4.697-2.362 1.507-5.090 2.303-7.889 2.303-1.208 0-2.403-0.149-3.561-0.439l-2.403 2.403c1.866 0.671 3.873 1.036 5.964 1.036 6.978 0 13.027-4.064 16-10-1.407-2.81-3.504-5.2-6.062-6.938z"></path></svg>');
	editor.ui.registry.addIcon('icon-spoiler', '<svg height="20" width="20" viewBox="0 0 24 24"><path d="M12.984 17.016q-0.422 0-0.703-0.305t-0.281-0.727 0.281-0.703 0.703-0.281 0.727 0.281 0.305 0.703-0.305 0.727-0.727 0.305zM12.984 12.984q-0.422 0-0.703-0.281t-0.281-0.703 0.281-0.703 0.703-0.281 0.727 0.281 0.305 0.703-0.305 0.703-0.727 0.281zM12.984 9q-0.422 0-0.703-0.281t-0.281-0.703 0.281-0.727 0.703-0.305 0.727 0.305 0.305 0.727-0.305 0.703-0.727 0.281zM17.016 12.516q-0.516 0-0.516-0.516t0.516-0.516q0.469 0 0.469 0.516t-0.469 0.516zM17.016 8.484q-0.516 0-0.516-0.469 0-0.516 0.516-0.516 0.469 0 0.469 0.516 0 0.469-0.469 0.469zM3 3h18v2.016h-18v-2.016zM17.016 16.5q-0.516 0-0.516-0.516 0-0.469 0.516-0.469 0.469 0 0.469 0.469 0 0.516-0.469 0.516zM9 17.016q-0.422 0-0.703-0.305t-0.281-0.727 0.281-0.703 0.703-0.281 0.703 0.281 0.281 0.703-0.281 0.727-0.703 0.305zM5.016 13.5q-0.609 0-1.055-0.422t-0.445-1.078 0.445-1.078 1.055-0.422 1.055 0.422 0.445 1.078-0.445 1.078-1.055 0.422zM5.016 9.516q-0.609 0-1.055-0.445t-0.445-1.055 0.445-1.055 1.055-0.445 1.055 0.445 0.445 1.055-0.445 1.055-1.055 0.445zM3 21v-2.016h18v2.016h-18zM9 9q-0.422 0-0.703-0.281t-0.281-0.703 0.281-0.727 0.703-0.305 0.703 0.305 0.281 0.727-0.281 0.703-0.703 0.281zM9 12.984q-0.422 0-0.703-0.281t-0.281-0.703 0.281-0.703 0.703-0.281 0.703 0.281 0.281 0.703-0.281 0.703-0.703 0.281zM5.016 17.484q-0.609 0-1.055-0.445t-0.445-1.055 0.445-1.055 1.055-0.445 1.055 0.445 0.445 1.055-0.445 1.055-1.055 0.445z"></path></svg>');
	editor.ui.registry.addIcon('icon-dle', '<svg height="24" width="24" viewBox="0 0 32 32"><path d="M8.984 9.047v-3.016h19v13.953h-3.016l0.062 3.031h-3.078v2.953h-18.936v-13.968h2.969v-3.016l2.999 0.063zM26.953 7h-17v2.047l15.078-0.062-0.062 10.031h1.984v-12.016zM24 10.016h-17.047v1.984h15v9.984h2.047v-11.968zM3.984 12.969v12.031h17v-12.031h-17z"></path></svg>');
	editor.ui.registry.addIcon('icon-font', '<svg width="18" height="18" viewBox="0 0 26 28"><path d="M11.328 8.734l-2.656 7.031c1.547 0.016 3.094 0.063 4.641 0.063 0.297 0 0.594-0.016 0.891-0.031-0.812-2.375-1.766-4.797-2.875-7.063zM0 26l0.031-1.234c1.469-0.453 3.063-0.141 3.719-1.828l3.703-9.625 4.375-11.312h2c0.063 0.109 0.125 0.219 0.172 0.328l3.203 7.5c1.172 2.766 2.25 5.563 3.437 8.313 0.703 1.625 1.25 3.297 2.031 4.891 0.109 0.25 0.328 0.719 0.547 0.891 0.516 0.406 1.953 0.5 2.688 0.781 0.047 0.297 0.094 0.594 0.094 0.891 0 0.141-0.016 0.266-0.016 0.406-1.984 0-3.969-0.25-5.953-0.25-2.047 0-4.094 0.172-6.141 0.234 0-0.406 0.016-0.812 0.063-1.219l2.047-0.438c0.422-0.094 1.25-0.203 1.25-0.781 0-0.562-2.016-5.203-2.266-5.844l-7.031-0.031c-0.406 0.906-1.984 5-1.984 5.594 0 1.203 2.297 1.25 3.187 1.375 0.016 0.297 0.016 0.594 0.016 0.906 0 0.141-0.016 0.281-0.031 0.422-1.813 0-3.641-0.313-5.453-0.313-0.219 0-0.531 0.094-0.75 0.125-0.984 0.172-1.953 0.219-2.938 0.219z"></path></svg>');

    editor.ui.registry.addButton('dletypo', {
        tooltip: 'Typographical Word Processing',
        icon: 'format',
        onAction: function () {
           if (tp) {

				const selectedHtml = editor.selection.getContent({ format: 'html' });

				if ( selectedHtml ) {

					editor.insertContent(tp.execute(selectedHtml));
					editor.undoManager.add();

				} else {

	                editor.setContent(tp.execute(editor.getContent()));
	                editor.undoManager.add();
				}

            }
        }
    });

	editor.ui.registry.addButton('dlemore', {
		tooltip: 'Additional formatting options',
		icon: 'action-next',
		onAction: function (api) {
			var toolbars = $('#' + editor.id).next().find('.tox-toolbar');
			
			if (toolbars.length > 1) {
				var lastToolbar = toolbars.last();
				
				if (lastToolbar.is(':visible')) {
					lastToolbar.slideUp();
					api.setIcon('action-next');

					try {
						localStorage.removeItem('dle_editor_' + editor.id);
					} catch (e) { }

				} else {

					lastToolbar.slideDown();
					api.setIcon('action-prev');
					
					try {
						localStorage.setItem('dle_editor_' + editor.id, '1');
					} catch (e) { }

				}

			}

		},
		onSetup: function (api) {
			var toolbars = $('#' + editor.id).next().find('.tox-toolbar');
			var state = null

			try {
				state = localStorage.getItem('dle_editor_' + editor.id);
			} catch (e) {}

			if (toolbars.length > 1 && !state) {
				toolbars.last().hide();
			} else {
				api.setIcon('action-prev');
			}
		}
	});

	editor.ui.registry.addButton('dleemo', {
		tooltip : 'Add emoticons',
		icon : 'emoji',
		onAction : function() {

			var ww = 430;
			var hh = 350;

			if (typeof getBaseSize === "function") {
				ww = ww * getBaseSize();
				hh = hh * getBaseSize();

				if(ww > ( $(window).width() * 0.95 ) )  { ww = $(window).width() * 0.95;  }
				if(hh > ( $(window).height() * 0.95 ) )  { hh = $(window).height() * 0.95;  }
			}

			editor.windowManager.openUrl({
			    title: "Add emoticons",
				url: editor.options.get('dle_root') + 'index.php?controller=ajax&mod=emotions&lang=' + editor.options.get('language'),
			    width: ww,
			    height: hh
			});
		}
    });

	editor.ui.registry.addButton('dleupload', {
		tooltip : 'Uploading files',
		icon: 'icon-up',
		onAction : function() {
			editor.focus();
			
			if(editor.queryCommandState('ToggleToolbarDrawer')) {
			  editor.execCommand('ToggleToolbarDrawer');
			}

			media_upload( editor.options.get('dle_upload_area'), editor.options.get('dle_upload_user'), editor.options.get('dle_upload_news'), '2');
		}
    });

	editor.ui.registry.addButton('dleleech', {
		tooltip : 'Insert protected link',
		icon : 'icon-leech',
		onAction : function() {
            editor.windowManager.open({
                title: 'Insert protected link',

  				body: {
    				type: 'panel', // The root body type - a Panel or TabPanel
				    items: [ // A list of panel components
							{
				              type: 'input',
				              name: 'href',
				              label: 'Url'
				            },
				            {type: 'input', 
								name: 'descr', 
								label: 'Description', 
							}
				      ]
				    },
			        initialData: {
			          descr: editor.selection.getContent()
			      },
				  buttons: [
				    {
				      type: 'cancel',
				      text: 'Cancel'
				    },
				    {
				      type: 'submit',
				      primary: true,
				      text: 'Insert'
				    }
				  ],
                onSubmit: function(e) {
                   var data = e.getData();
                   editor.insertContent('[leech=' +data.href+']' + data.descr +'[/leech]');
                   e.close();
                }
            });
		}
    });


	editor.ui.registry.addButton('dlequote', {
		tooltip : 'Insert quote',
		icon : 'quote',

		onAction: function() {
			
			const selectedHtml = editor.selection.getContent({ format: 'html' });

			if ( selectedHtml ) {

				const selectedBlocks = editor.selection.getSelectedBlocks();
				if (selectedBlocks.length === 0) return;

				const lastSelected = selectedBlocks[selectedBlocks.length - 1];
				const allParagraphs = editor.getBody().querySelectorAll('p');
				const lastParagraph = allParagraphs[allParagraphs.length - 1];

				const isLast = lastSelected === lastParagraph;

				const wrappedHtml = `
				  <div class="quote_block noncontenteditable">
					<div class="quote">
					  <div class="quote_body contenteditable">
						${selectedHtml}
					  </div>
					</div>
				  </div>
				  ${isLast ? '<p><br></p>' : ''}
				`;

				editor.insertContent(wrappedHtml);

			} else {


	            editor.windowManager.open({
	                title: 'Insert quote',
	                size: 'medium',

	  				body: {
	    				type: 'panel', // The root body type - a Panel or TabPanel
					    items: [ // A list of panel components
								{
					                    type: 'textarea',
					                    name: 'qttext',
					                }
					      ]
					    },
					  buttons: [ // A list of footer buttons
					    {
					      type: 'cancel',
					      text: 'Cancel'
					    },
					    {
					      type: 'submit',
					      primary: true,
					      text: 'Insert'
					    }
					  ],
	                onSubmit: function(e) {
	                   		var data = e.getData();

							var it = data.qttext.replace(/\n/g, '<br>');
							it = it.replace(/\r/g, '');

							editor.execCommand('mceReplaceContent',false,'<div class="quote_block noncontenteditable"><div class="quote"><div class="quote_body contenteditable">' + it + '</div></div></div><p><br></p>');
							e.close();

	                }
	            });


			}

		}
	});


	editor.ui.registry.addButton('dlehide', {
		tooltip : 'Insert hidden text',
		icon : 'icon-hide',
			
		onAction: function() {

			var selected_text = editor.selection.getContent();
			selected_text = selected_text.replace(/<br>/g, "\n");
			selected_text = $('<span>'+selected_text+'</span>').text();

            editor.windowManager.open({
                title: 'Insert hidden text',
                size: 'medium',

  				body: {
    				type: 'panel', // The root body type - a Panel or TabPanel
				    items: [ // A list of panel components
							{
				                    type: 'textarea',
				                    name: 'qttext'
				                }
				      ]
				    },
		        initialData: {
		          qttext: selected_text
		     	},
				buttons: [ // A list of footer buttons
				    {
				      type: 'cancel',
				      text: 'Cancel'
				    },
				    {
				      type: 'submit',
				      primary: true,
				      text: 'Insert'
				    }
				  ],
                onSubmit: function(e) {
                   		var data = e.getData();

						var text = data.qttext;
						text = text.replace(/</g, '&lt;');
						text = text.replace(/>/g, '&gt;');

						text = text.replace(/\n/g, '<br>');
						text = text.replace(/\r/g, '');

						editor.execCommand('mceReplaceContent',false,'[hide]' +text +'[/hide]');
						e.close();

                }
            });

		}
	});

	editor.ui.registry.addButton('dlespoiler', {
		tooltip : 'Insert spoiler',
		icon : 'icon-spoiler',
		onAction : function() {

			var selected_text = editor.selection.getContent();
			selected_text = selected_text.replace(/<br>/g, "\n");
			selected_text = $('<span>'+selected_text+'</span>').text();

            editor.windowManager.open({
                title: 'Insert spoiler',
                size: 'medium',

  				body: {
    				type: 'panel', // The root body type - a Panel or TabPanel
				    items: [ // A list of panel components
							{
				                    type: 'textarea',
				                    name: 'qttext'
				                }
				      ]
				    },
		        initialData: {
		          qttext: selected_text
		     	},
				buttons: [ // A list of footer buttons
				    {
				      type: 'cancel',
				      text: 'Cancel'
				    },
				    {
				      type: 'submit',
				      primary: true,
				      text: 'Insert'
				    }
				  ],
                onSubmit: function(e) {
                   		var data = e.getData();

						var text = data.qttext;
						text = text.replace(/</g, '&lt;');
						text = text.replace(/>/g, '&gt;');

						text = text.replace(/\n/g, '<br>');
						text = text.replace(/\r/g, '');

						editor.execCommand('mceReplaceContent', false, '<div>[spoiler]' + text + '[/spoiler]</div>');
						
						e.close();

                }
            });
		}
    });

	editor.ui.registry.addButton('dletube', {
		tooltip : 'Play video from media services',
		icon : 'icon-yt',

		onAction : function() {

            editor.windowManager.open({
                title: 'Play video from media services',

  				body: {
    				type: 'panel', // The root body type - a Panel or TabPanel
				    items: [ // A list of panel components
							{
				                type: 'input',
				                name: 'href',
				                label: 'Url'
				            },
				            {
							  type: 'alertbanner',
							  level: 'info',
							  text: 'Inserting content from media services. You can insert content from services such as Youtube, Instagram, Facebook and etc.',
							  icon: 'help'
							}
				      ]
				    },
				  buttons: [ // A list of footer buttons
				    {
				      type: 'cancel',
				      text: 'Cancel'
				    },
				    {
				      type: 'submit',
				      primary: true,
				      text: 'Insert'
				    }
				  ],
                onSubmit: function(e) {

                   		var data = e.getData();

						editor.insertContent('[media=' + data.href + ']' + '<span id="EdCaReT"></span>');

						var node = editor.selection.getNode();

						if (node.nodeName == 'P') {

							var stylenode = editor.dom.getAttrib(node, 'style');
							var classnode = editor.dom.getAttrib(node, 'class');

							if (stylenode) {
								stylenode = ' style="' + stylenode + '"';
							}

							if (classnode) {
								classnode = ' class="' + classnode + '"';
							}

							var newnode = '<div' + stylenode + classnode + '>' + editor.selection.select(node).innerHTML + '</div>';

							editor.selection.select(node);
							editor.insertContent(newnode);

						}

						var el = editor.dom.select('span#EdCaReT')[0];
						if (el) {
							editor.selection.scrollIntoView(el);
							editor.selection.setCursorLocation(el, 0);
							editor.dom.remove(el);
						}

						e.close();

                }
            });

		}
    });

	editor.ui.registry.addButton('dlepage', {
		tooltip : 'Insert link to the page',
		icon : 'icon-pl',
		onAction : function() {
			editor.windowManager.open({
                title: 'Insert link to the page',

   				body: {
    				type: 'panel', // The root body type - a Panel or TabPanel
				    items: [ // A list of panel components
							{
				                type: 'input',
				                name: 'href',
				                label: 'Page Number'
				            },
							{
				                type: 'input',
				                name: 'text',
				                label: 'Text to display'
				            },
				      ]
				    },

			      initialData: {
			          text: editor.selection.getContent(),
			          href: '1'
			      },
				  buttons: [ // A list of footer buttons
				    {
				      type: 'cancel',
				      text: 'Cancel'
				    },
				    {
				      type: 'submit',
				      primary: true,
				      text: 'Insert'
				    }
				  ],

                onSubmit: function(e) {
                   		var data = e.getData();

						editor.insertContent('[page=' +data.href +']' + data.text +'[/page]');

						e.close();

                }

            });
		}
    });

	editor.ui.registry.addButton('dlemp', {
		tooltip : 'Insert video (BB Codes)',
		icon: 'embed',

		onAction : function() {

			var win = {
                title: 'Insert video (BB Codes)',

  				body: {
    				type: 'panel', // The root body type - a Panel or TabPanel
				    items: [ // A list of panel components
							{
				              type: 'input',
				              name: 'href',
				              label: 'Url'
				            },
				            {type: 'input', 
								name: 'descr', 
								label: 'Description', 
							},
				            {type: 'input', 
								name: 'poster', 
								label: 'Link to poster', 
							}
				          ]
				},

				buttons: [ // A list of footer buttons
				    {
				      type: 'cancel',
				      text: 'Close'
				    },
				    {
				      type: 'custom',
				      name: 'addbtn',
				      primary: true,
				      text: 'Add to Playlist'
				    },

				    {
				      type: 'submit',
				      name: 'submitbtn',
				      primary: true,
				      text: 'Insert'
				    }
				  ],

				onAction: function(dialogApi, details) {

					var data = dialogApi.getData();

					var videourl = data.href;
					var videoposter = data.poster;
					var videodescr = data.descr;
								
					var videolink = videourl;

					if (videoposter != "" || videodescr != "" ) { 
						videolink += '|' + videoposter;
					}
								
					if (videodescr != "" ) { 
						videolink += '|' + videodescr;
					}

					if (videolink != "") {
						playlist +=  videolink + ',';
					}
								
					dialogApi.redial(win);
				},

                onSubmit: function(dialogApi) {

					var data = dialogApi.getData();
					
					var videolink = data.href;
					var poster = data.poster;
					var descr = data.descr;

					if (poster != "" || descr != "" ) { 
						videolink += '|' + poster;
					}
					
					if (descr != "" ) { 
						videolink += '|' + descr;
					}
					
					if(videolink != "" && videolink != "https://") {
						playlist += videolink;
					}else if(playlist != "") {
						playlist = playlist.substring(0, playlist.length - 1)
					}

					if(playlist != "") {
						editor.insertContent('[video=' + playlist + ']' + '<span id="EdCaReT"></span>');
                   	}

					var node = editor.selection.getNode();

					if (node.nodeName == 'P') {
						
						var stylenode = editor.dom.getAttrib(node, 'style');
						var classnode = editor.dom.getAttrib(node, 'class');

						if (stylenode) {
							stylenode = ' style="' + stylenode + '"';
						}

						if (classnode) {
							classnode = ' class="' + classnode + '"';
						}

						var newnode = '<div' + stylenode + classnode + '>' + editor.selection.select(node).innerHTML + '</div>';

						editor.selection.select(node);
						editor.insertContent(newnode);

					}

					// Set cursor:
					var el = editor.dom.select('span#EdCaReT')[0];
					if (el) {
						editor.selection.scrollIntoView(el);
						editor.selection.setCursorLocation(el, 0);
						editor.dom.remove(el);
					}

					playlist = '';
					dialogApi.close();
                }
            };

           editor.windowManager.open( win );

		}

    });

	editor.ui.registry.addButton('dlaudio', {
		tooltip : 'Insert audio (BB Codes)',
		icon: 'icon-audio',

		onAction : function() {

			var win = {
                title: 'Insert audio (BB Codes)',

  				body: {
    				type: 'panel', // The root body type - a Panel or TabPanel
				    items: [ // A list of panel components
							{
				              type: 'input',
				              name: 'href',
				              label: 'Url'
				            },
				            {type: 'input', 
								name: 'descr', 
								label: 'Description', 
							}
				          ]
				},

				buttons: [ // A list of footer buttons
				    {
				      type: 'cancel',
				      text: 'Close'
				    },
				    {
				      type: 'custom',
				      name: 'addbtn',
				      primary: true,
				      text: 'Add to Playlist'
				    },

				    {
				      type: 'submit',
				      name: 'submitbtn',
				      primary: true,
				      text: 'Insert'
				    }
				  ],

				onAction: function(dialogApi, details) {

					var data = dialogApi.getData();

					var videourl = data.href;
					var videodescr = data.descr;
								
					var videolink = videourl;
					
					if (videodescr != "" ) { 
						videolink += '|' + videodescr;
					}
					
					if (videolink != "") {
						playlist +=  videolink + ',';
					}
								
					dialogApi.redial(win);
				},

                onSubmit: function(dialogApi) {

					var data = dialogApi.getData();
					
					var videolink = data.href;
					var descr = data.descr;

					if (descr != "" ) { 
						videolink += '|' + descr;
					}
					
					if(videolink != "") {
						playlist += videolink;
					}else if(playlist != "") {
						playlist = playlist.substring(0, playlist.length - 1);
					}

					if(playlist != "") {
						editor.insertContent('[audio=' + playlist + ']' + '<span id="EdCaReT"></span>');
                   	}

					var node = editor.selection.getNode();

					if (node.nodeName == 'P') {

						var stylenode = editor.dom.getAttrib(node, 'style');
						var classnode = editor.dom.getAttrib(node, 'class');

						if (stylenode) {
							stylenode = ' style="' + stylenode + '"';
						}

						if (classnode) {
							classnode = ' class="' + classnode + '"';
						}

						var newnode = '<div' + stylenode + classnode + '>' + editor.selection.select(node).innerHTML + '</div>';

						editor.selection.select(node);
						editor.insertContent(newnode);

					}

					// Set cursor:
					var el = editor.dom.select('span#EdCaReT')[0];
					if (el) {
						editor.selection.scrollIntoView(el);
						editor.selection.setCursorLocation(el, 0);
						editor.dom.remove(el);
					}

					playlist = '';

					dialogApi.close();
                }
            };

           editor.windowManager.open( win );

		}

    });



	editor.ui.registry.addButton('dleimage', {
		tooltip : 'Insert image',
		icon : 'image',

		onAction : function() {
			editor.windowManager.open({
                title: 'Insert image',

   				body: {
    				type: 'panel', // The root body type - a Panel or TabPanel
				    items: [ // A list of panel components
							{
				                type: 'input',
				                name: 'href',
				                label: 'Url'
				            },
							{
				                type: 'input',
				                name: 'text',
				                label: 'Image description'
				            },
				            {
			                    type: 'listbox',
			                    name: 'align',
			                    label: 'Alignment',

								  items: [
								    { text: 'None', value: '' },
								    { text: 'Left', value: 'left' },
								    { text: 'Right', value: 'right' },
								    { text: 'Center', value: 'center' }
								    ]

			                }
				      ]
				    },
				  buttons: [ // A list of footer buttons
				    {
				      type: 'cancel',
				      text: 'Cancel'
				    },
				    {
				      type: 'submit',
				      primary: true,
				      text: 'Insert'
				    }
				  ],

                onSubmit: function(e) {
                   		var data = e.getData();

						var imageurl = data.href;
						var imagealt = data.text;
						var imagealign = data.align;
						
						var imgoption = "";
				
						if (imagealt != "") { 
				
							imgoption = "|"+imagealt;
				
						}
				
						if (imagealign != "" && imagealign != "center") { 
				
							imgoption = imagealign+imgoption;
				
						}
				
						if (imgoption != "" ) {
				
							imgoption = "="+imgoption;
				
						}
				
						if (imagealign == "center") {
							editor.insertContent('<p style="text-align: center;">[img'+imgoption+']'+imageurl+'[/img]</p>');
						}
						else {
							editor.insertContent("[img"+imgoption+"]"+imageurl+"[/img]", "", false);
						}

						e.close();

                }

            });
		}
    });



});